package com.burhanstore.neonbubblequest.act

import android.app.Activity
import android.app.Dialog
import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.burhanstore.neonbubblequest.AppConst
import com.burhanstore.neonbubblequest.Utils.DialogManager
import com.burhanstore.neonbubblequest.Utils.adapter.PaymentAdapter
import com.burhanstore.neonbubblequest.Utils.anim.AnimationHelper
import com.burhanstore.neonbubblequest.Utils.anim.setClick
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.burhanstore.neonbubblequest.Utils.model.PaymentModel
import com.burhanstore.neonbubblequest.Utils.network.AppNetworkAdapter
import com.burhanstore.neonbubblequest.Utils.response.PaymentResponse
import com.burhanstore.neonbubblequest.databinding.ActivityPaymentBinding
import com.google.gson.Gson
import com.google.gson.JsonObject
import kotlinx.coroutines.launch

class PaymentActivity : AppCompatActivity() {


    private lateinit var binding: ActivityPaymentBinding
    private lateinit var activity: Activity

    private var uid: String = ""

    private lateinit var user_m: UserManager
    private var dialog_redeem: Dialog? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityPaymentBinding.inflate(layoutInflater)
        setContentView(binding.root)
        activity = this

        DialogManager.initDialog(activity)
        binding.imageView2.setClick { finish() }

        user_m = UserManager.Companion.getInstance(activity)
        uid = user_m.getUser()?.u_id ?: ""


        redeem_get()


        binding.redeemHistoryBtn.setClick {
            val intent = Intent(activity, RedeemsActivity::class.java)
            startActivity(intent)
            AnimationHelper.applySlideZoomTransition(activity)
        }


    }


    private fun redeem_get() {

        val json = JsonObject().apply {
            addProperty("action", "get_pyament_methods")
            addProperty("u_id", uid)
        }
        AppNetworkAdapter.sendRequest(
            lifecycleScope,
            json,
            object : AppNetworkAdapter.ResponseHandler {
                override fun onSuccess(response: JsonObject?) {
                    Log.d("QuickBonus", "Success: $response")

                    lifecycleScope.launch {
                        try {
                            val quickBonusResponse =
                                Gson().fromJson(response, PaymentResponse::class.java)
                            val data = quickBonusResponse.payment

                            val dbUser = quickBonusResponse.user

                            AppConst.setString(
                                activity, AppConst.USER_COIN, dbUser.point ?: "0"
                            )

                            update_data(data)
                        } catch (e: Exception) {
                            Log.e("QuickBonus", "Parsing error: ${e.message}")
                        }
                    }
                }

                override fun onError(code: Int, message: String?) {
                    Log.e("QuickBonus", "Error $code: $message")
                }

                override fun onException(exception: Exception) {
                    Log.e("QuickBonus", "Exception: ", exception)
                }
            }


        )


    }

    private fun update_data(data: List<PaymentModel>) {
        binding.coinsTextview.text = AppConst.getString(this, AppConst.USER_COIN)
        val userCoin = AppConst.getString(this, AppConst.USER_COIN).toIntOrNull() ?: 0
        binding.redeemList.layoutManager =
            LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false)
        binding.redeemList.adapter = PaymentAdapter(data) { paymentItem ->

            val intent = Intent(activity, RedeemViewActivity::class.java).apply {
                putExtra("item_id", paymentItem.id)
                putExtra("py_title", paymentItem.py_title)
                putExtra("py_rcoin", paymentItem.py_rcoin)
                putExtra("py_amout", paymentItem.py_amout)
                putExtra("py_currency", paymentItem.py_currency)
                putExtra("py_inouthint", paymentItem.py_inouthint)
                putExtra("py_inputhint2", paymentItem.py_inputhint2)
                putExtra("py_logo", paymentItem.py_logo)

            }
            startActivity(intent)


        }
    }


    override fun onPostResume() {
        super.onPostResume()
        binding.coinsTextview.text = AppConst.getString(activity, AppConst.USER_COIN)

    }
}